// plasma volume by public_int_i
//Ethan Alexander Shulman 2016
//https://www.shadertoy.com/view/lt2XWd
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
#define iTime u_Elapsed  //*0.3141592
#define iResolution u_WindowSize
//
#define iMouse vec4(0.0,0.0,0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif

float len(vec3 p) {
    return max(abs(p.x)*0.5+abs(p.z)*0.5,max(abs(p.y)*0.5+abs(p.x)*0.5,abs(p.z)*0.5+abs(p.y)*0.5));
}

void main( void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 R = iResolution.xy,
        uv = (gl_FragCoord.xy - .5*R) / iResolution.y;
    
    vec3 rp = vec3(0.,iMouse.y/50.,iTime+iMouse.x/50.);
    vec3 rd = normalize(vec3(uv,1.));
    
    vec3 c = vec3(0.);
    float s = 0.;
    
    float viewVary = cos(iTime*0.05)*.15;
    
    for (int i = 0; i < 74; i++) {
        vec3 hp = rp+rd*s;
        float d = len(cos(hp*.6+
                             cos(hp*.3+iTime*.5)))-.75;
        float cc = min(1.,pow(max(0., 1.-abs(d)*10.25),1.))/(float(i)*1.+10.);//clamp(1.-(d*.5+(d*5.)/s),-1.,1.);
        
        c += (cos(vec3(hp.xy,s))*.5+.5 + cos(vec3(s+iTime,hp.yx)*.1)*.5+.5 + 1.)/3.
              *cc;
        
        s += max(abs(d),0.35+viewVary);
        rd = normalize(rd+vec3(sin(s*0.5),cos(s*0.5),0.)*d*0.05*clamp(s-1.,0.,1.));
    }
    
    gl_FragColor = vec4(pow(c,vec3(1.7)),1.);
}